//
// TRACKER SCHEME RESOURCE FILE //Small HUD 9 Black by INsane STANDARD FONTS updated to new file enties 1 MAY 2011
//
// sections:
//		colors			- all the colors used by the scheme
//		basesettings	- contains settings for app to use to draw controls
//		fonts			- list of all the fonts used by app
//		borders			- description of all the borders
//
//
Scheme
{
	//Name - currently overriden in code
	//{
	//	"Name"	"ClientScheme"
	//}

	//////////////////////// COLORS ///////////////////////////
	// Color details used in INsanes HUDs
	// This is a list of all the colors used by the scheme
	// INsanes desription has a code for what file this color is in. CS = ClientScheme.res  HL = HudLayout.res  HA = HudAnimations.txt
	//Main Colors of the Scheme	  White = "255 255 255 255"  Blue = "26 140 255 255"	Green = "124 252 0 225"		
	Colors
	{
	// base colors LEAVE ALONE, DEFAULT COLORS!!!  INsane
		"Orange"			      "255 176 0 255"
		"OrangeDim"			      "255 176 0 120"
		"LightOrange"		      "188 112 0 128"
		
		"Red"				      "192 28 0 140"
		"Black"				      "0 0 0 255"
		"TransparentBlack"	      "0 0 0 196"
		"TransparentLightBlack"	  "0 0 0 200"
		"DarkerTransparentBlack"  "0 0 0 230"			

		"White"				      "255 255 255 255"
		"TransparentWhite"	      "255 255 255 128"
		"MoreTransparentWhite"	  "255 255 255 64"


	    // START INsanes HUD base colors
		"test"				  "255 30 255 255"     //used to test only. Pink
		
		
		//Main Colors of the Scheme	  White = "255 255 255 255"  Blue = "150 200 255 255"	Green = "124 252 0 225"
		
		"Main_Color"	        "255 255 255 255"     //CS HA Solid color Hud Icons and major text areas. 

		"HUD_Panel_dodLogo"	    "255 255 255 255"	  //CS Color of the dods Logo on the HUD.     Usually the same as "Main_Color" or White = "255 255 255 255"
		"Main_Menu_Title"	    "255 255 255 255"	  //CS Color of the dods Logo on Main Menu.   Usually the same as "Main_Color" or White = "255 255 255 255"


		//Titles and Buttons	
		"Main_Color_Light"      "245 245 245 255"     //CS	A Pastal color shade of blue or green...very whiteish for titles and buttons 	White = "255 255 255 255"  Blue LightCyan = "224 255 255 255" Green Honeydew = "240 255 240 225"
		"Main_Color_Disabled"   "255 255 255 100"     //CS	A Dim Pastal color shade of blue or green...very whiteish for titles and buttons that are disabled			
		"Hud_Hint_Text"	        "255 255 255 255"	  //CS Color of the Hud Hint Text only.   Usually the same as "Main_Color" or White = "255 255 255 255"
		
		//Kills and Deaths background		
		"HudKillsDeathsOthers"		"0 0 0 100"       // Background of Kills/Deaths- Other players.
		"HudKillsDeathsYou"		    "0 0 0 210"       // Background of Kills/Deaths- YOU!
		
		//Warning Colours, MG overheat	and Fire Select Bullets on right lower icons
		"Warn_Orange"              "255 215 0 255"    //TEST  // * Added found new color investigate Orange = "255 215 0 255"
		"Warn_Yellow"              "255 255 0 255"    //TEST  // * Added found new color investigate  Yellow = "255 255 0 255"  Silver "192 192 192 255"
		
		//MG Icons
		"MG_Icon_Norm"             "34 139 34 190"    // ForestGreen * MG... Icon Color "cool-warm" of the Icon in MG heat bar.
		"MG_Icon_Hot"              "255 0 0 255"      // Red         * MG... Icon Color "HOT-Overheated" of the Icon in MG heat bar.
		
		//MG Bar
		"MG_Bar_Cold"              "34 139 34 190"    // ForestGreen * MG... 1st Color "Cold" of the Bar in MG heat bar.		
        "MG_Bar_Warm"              "255 255 0 150"    // Yellow      * MG... 2nd Color "Warm" of the Bar and Icon in MG heat bar.	
		"MG_Bar_Hot"               "255 0 0 255"      // Red         * MG... 3rd Color "HOT" of the Bar and Icon in MG heat bar.
		"MG_Bar_OverHeat"          "255 165 0 190"    // Orange      * MG... 4th Color "Overheated, wait cool down" of the Bar in MG heat bar.
		
		
 	    //Fireselect, Mp44 and BAR colors			
		"Mp44_Icon_FS"             "200 200 200 255"   // * Color of the fireselect Mp44 Icons. Make "0 0 0 0" to turn off
		"BAR_Icon_FS"              "200 200 200 255"   // * Color of the fireselect BAR Icons. Make "0 0 0 0" to turn off		
		"Bullet_Icon_SingleRight"  "200 0 0 255"       // * Color of the single fire fireselect Icons/bullet right or the single fire icon in INsane mod 
	    "Bullet_Icon_AutoMid"      "200 200 200 255"   // * Color of the middle auto fireselect Icons/bullet middle or the auto fire icon in INsane mod 
	    "Bullet_Icon_AutoLeft"     "200 200 200 255"   // * Color of the left auto fireselect Icons/bullet left.

		
		//Objective Icons		
		"Objectives_Foreground"    "0 0 0 90"         // * object icons foregound  No effect on INsanes hud will on standard icon setting in HudLayout
		"Objectives_Background"    "0 0 0 90"         // * The Fill color around the object icons in the upper left corner. No effect on INsanes hud will on standard icon setting in HudLayout
		"Objectives_Border"        "0 0 0 225"        // * This is the Border color for the object icons. No effect on INsanes hud will on standard icon setting in HudLayout

		//Capture Panel Colors	
		"Cap_Icon_Mate_Go"         "255 255 255 255"  //  * The color of the left capture Icon when you are capping. You are the left icon.
		"Cap_Icon_Mate_Stop"       "255 0 0 255"      //  * The color of the Right icons, (your teammates) when waiting for a teammate also shows how many.
		"Cap_Bar_Stop"             "255 255 255 255"  //  * Color of the Capture bar segments before the other one takes over. Amount left color
		"Cap_Bar_Go"               "255 0 0 255"      //  * Color of the Capture bar segments when counting down. Amount Captured color.		

		//Scoreboard colors		
		"Scoreboard_Back"          "0 0 0 220"        // "0 0 0 220"       * A scoreboard color... Background
        "ScoreHeaderText"		   "110 110 110 255"  // "255 255 255 200" * A scoreboard color... Header Text
		"ScoreHeaderHiLt"		   "255 255 255 32"   // "255 255 255 32"  * A scoreboard color... Highlights YOUR name.

		
		// END INsanes HUD base colors
		
		// Start VALVes special dods colors... edited by INsane	
	
		
		"ClassInfoBackground"	  "255 255 255 32"           //"255 255 255 32"	*The background color of the "SELECTED PLAYER:" section in the class select menu.	
		"WeaponInfoBackground"	  "255 255 255 16"           //"255 255 255 16" *The background color of the "PRIMARY WEAPONS:" and "OTHER WEAPONS:" section in the class select menu.

		"ClassMenuLight"	      "251 207 59 255"           //"251 207 59 255" *The "left over" color in the Bar Graphs in the "PRIMARY WEAPONS:" section in the class select menu.
		"ClassMenuDark"		      "144 134 98 155"           //"144 134 98 155" *The color of the Bar in the Bar Graphs in the "PRIMARY WEAPONS:" section in the class select menu.		
		
		"Yellow"			      "251 206 60 255"           //* Default color. don't change.
		
		// Player Status Panel colors VALVe
		"HudPanelForeground"		  "0 0 0 90"             //"123 110 59 184"   *This is the Fill color for player status panel.
		"HudPanelBackground"		  "0 0 0 190"            //"123 110 59 184"   *Changed by INsane NOW IS MAJOR BACKGROUND COLORS see above "Objectives_Background"... Was the Fill color around the object icons in the upper left corner.
		"HudPanelBorder"			  "0 0 0 225"            //"255 255 255 102"  *This is the Border color for player status panel and the the object icons.
		
		// Stamina colors VALVe
		"HudProgressBarActive"		  "34 139 34 190"    // ForestGreen  Ver 7 ?               //"240 207 78 255"  * Stamina... 1st Color "Rested" of the Bar (and Icon) in Stamina bar when rested, Color of the Capture bar segments before the other one takes over. Color of the fireselect Icons/bullets.
		"HudProgressBarInActive"	  "255 255 0 150"    // Yellow       Ver7 "0 0 0 150"      //"140 120 73 255"  * Stamina... 2nd Color "Good stamina" of the Bar in Stamina bar when starting to run. Color of the Capture bar segments when counting down.
		"HudProgressBarActiveLow"	  "255 0 0 255"      // Red          Ver7 "255 176 0 255"  //"240 30 30 255"   * Stamina... 3rd Color "About to Slow down" of the Bar (and Icon) in Stamina bar when running. Kicks in at about 3-4 seconds.
		"HudProgressBarInActiveLow"	  "255 165 0 190"    // Orange       Ver7 "240 30 30 255"  //"240 30 30 99"    * Stamina... 4th Color "Exhausted, now at walking pace" of the Bar (and Icon) in Stamina bar when running.	
 
        // Stamina colors INsane Added	
		"Stamina_Icon_OK"                 "34 139 34 190"    //ForestGreen  Ver9    // * Stamina Icon color... 1st Color "Rested - Good stamina".
		"Stamina_Icon_Exhausted"          "255 0 0 255"      //Red          Ver9    // * Stamina Icon color... 2nd Color "About to Slow down - Exhausted, now at walking pace".
		
        // Timer colors VALVe		
		"HudPanelObjectivesTimer"		"127 127 127 127"    // * The Background color of the Large Timer and small "drop down, extra time" Timer on dod_jagd.
		"HudPanelObjectivesTimer_Flash"	"180 180 180 127"    // * The Background color of the Large Timer (WHEN IT FLASHES)on dod_jagd. The small "drop down, extra time" Timer does not flash this color.

        // Ammo clip colors VALVe		
		"HudAmmoCount"				     "255 255 255 255"   //"240 207 78 127" * Color of the numbers that tell you how many ammo clips and MG bullets are left.

        // Health colors VALVe		
		"HudHealthGreen"			     "30 30 30 255"   //(V9 HUD Dk Grey) Standard hud "85 112 66 255"    * Green.......... 100% to 50% 1st color, Good health to medium injury. Starts its count at the top and finishes at the 50% mark.
		"HudHealthYellow"			     "255 165 0 255"  //(V9 HUD Orange)  Standard hud "240 207 78 255"   * Yellow/gold.... 50% to 75%  2nd color, medium damage level to high. Starts it's countdown in the middle of the bar and finishes at the 75% mark.
		"HudHealthRed"				     "255 0 0 255"    //(V9 HUD Red)     Standard hud "180 20 20 255"    * Red............ 75% to 100% 3rd color, High damage to death. Starts it's countdown on the 75% mark of the bar and finishes at the Bottom.
		"HudHealthBG"				     "0 0 0 0"        //(V9 HUD Blank)   Standard hud "170 150 73 255"   * Tan/gold, the color you see color as the green, yellow/gold and red count down.
		"HudHealthBorder"			     "0 0 0 255"      //(V9 HUD Black)   Standard hud "255 255 255 255"  * White, Health bar boarder.
		

        // Weapon selection INsane added
		"Weapon_Pick_Up"                "255 0 0 255"        // Added INsane Red =    "255 0 0 255" THIS WILL ALTER THE COLOR OF THE PICKED UP ITEMS ICONS dods may not support this
		"Weapon_Selected_Border"        "255 255 255 60"     // Added INsane    * The weapon select panel boarder. The one that IS selected.
        "Weapon_Deselected_Border"      "0 0 0 130"		     // Added INsane    * The weapon select panel boarder. The ones that ARE NOT selected.
		
        // Weapon selection VALVe		
		"HudBackground"					"0 0 0 90"           //"123 110 59 184" * Used in the background of the weapon select panels. The ones that ARE NOT selected.
		"HudBackgroundActive"			"100 120 66 60"      //"240 207 78 117" * Used in the background of the weapon select panels. The one that IS selected.
		"HudBackgroundUnusable"			"192 28 0 60"        //"192 28 0 140"   * Used in the background of the weapon select panels. The one that HAS RUN OUT OF AMMO.
		"HudBackgroundActiveSolid"		"0 0 0 0"            //"240 207 78 180" * NOT USED IN INsanes HUDs.... disabled, was...background of the kills caps deaths panels. (Your Kills, Caps and Deaths not other players).		

		"CommentaryBG"					"0 0 0 76"
		
		"Blank"				            "0 0 0 0"
	}

	///////////////////// BASE SETTINGS ////////////////////////
	//
	// default settings for all panels
	// controls use these to determine their settings
	BaseSettings
	{
		// vgui_controls color specifications
		Border.Bright					"TransparentWhite"    // * The top and left (lit side) of boxes/scrollbars/checkboxes
		Border.Dark					    "TransparentWhite"    // * The bottom and right (dark/unlit side) of boxes/scrollbars/checkboxes	
		Border.Selection				"Blank"               // * The additional border color for displaying the default/selected button	

		Button.TextColor				"Main_Color_Light"   //"245 245 245 200"    // * Unselected button Text title, it does not work on all text tiles in buttons. See "Label.TextColor" "Label.DisabledFgColor2" for these other buttons.	
		Button.BgColor					"200 200 200 50"     // * The background color of an unselected button while Hovering mouse.
		Button.ArmedTextColor			"Main_Color_Light"   //"255 255 255 220" // * (Selected button/hud numbers while Hovering mouse)The Selection Numbers/boarders/text on selected Buttons/images in classmenu and team select screens.
		Button.ArmedBgColor				"119 136 153 50"     // * The background color of a Selected button while Hovering mouse.
		Button.DepressedTextColor		"245 245 245 50"     // * The color the boarders/text in buttons ...flashes this color when pressed.
		Button.DepressedBgColor			"20 20 20 50"        // * The color the background in buttons ...flashes this color when pressed.

		CheckButton.TextColor			"Yellow"            //"Yellow"           * The font color of the words beside a checkbutton when disabled.
		CheckButton.SelectedTextColor	"Yellow"            //"Yellow"           * The font color of the words beside a checkbutton when enabled.
		CheckButton.BgColor				"TransparentBlack"  //"TransparentBlack" * checkbutton background
		CheckButton.Border1  			"Border.Dark"       //"Border.Dark"      * the left checkbutton border
		CheckButton.Border2  			"Border.Bright"		// "Border.Dark"     * the right checkbutton border
		CheckButton.Check				"Yellow" 			// "Yellow"          * color of the check itself

		ComboBoxButton.ArrowColor		"Main_Color_Light"  //"White"  //"Orange"   * Unselected color of the arrow in the spectator view combo box.
		ComboBoxButton.ArmedArrowColor	"Main_Color_Light"  //"White"  //"Orange"   * Selected color of the arrow in the spectator view combo box.
		ComboBoxButton.BgColor			"TransparentBlack"  //"TransparentBlack"    * Background color of the spectator view combo box.
		ComboBoxButton.DisabledBgColor	"Blank"             //"Blank"               * don't know no HUD effect

		Frame.BgColor					"TransparentBlack" //"TransparentBlack"    * don't know no HUD effect
		Frame.OutOfFocusBgColor			"TransparentBlack" //"TransparentBlack"    * don't know no HUD effect
		Frame.FocusTransitionEffectTime	"0.0"	           // "0.0"                * time it takes for a window to fade in/out on focus/out of focus
		Frame.TransitionEffectTime		"0.0"	           // "0.0"                * time it takes for a window to fade in/out on open/close
		Frame.AutoSnapRange				"0"                // "0"                  * don't know no HUD effect
		FrameGrip.Color1				"Blank"            // "Blank"              * don't know no HUD effect
		FrameGrip.Color2				"Blank"            // "Blank"              * don't know no HUD effect
		FrameTitleButton.FgColor		"Blank"            // "Blank"              * don't know no HUD effect
		FrameTitleButton.BgColor		"Blank"            // "Blank"              * don't know no HUD effect
		FrameTitleButton.DisabledFgColor	"Blank"        // "Blank"              * don't know no HUD effect
		FrameTitleButton.DisabledBgColor	"Blank"        // "Blank"              * don't know no HUD effect
		FrameSystemButton.FgColor		"Blank"            // "Blank"              * don't know no HUD effect
		FrameSystemButton.BgColor		"Blank"            // "Blank"              * don't know no HUD effect
		FrameSystemButton.Icon			""                 // ""                   * don't know no HUD effect
		FrameSystemButton.DisabledIcon	""                 // ""                   * don't know no HUD effect
		FrameTitleBar.TextColor			"Orange"           // "Orange"             * don't know no HUD effect
		FrameTitleBar.BgColor			"Blank"            // "Blank"              * don't know no HUD effect
		FrameTitleBar.DisabledTextColor	"Orange"           // "Orange"             * don't know no HUD effect
		FrameTitleBar.DisabledBgColor	"Blank"            // "Blank"              * don't know no HUD effect

		GraphPanel.FgColor				"Orange"           // "Orange"             * don't know no HUD effect
		GraphPanel.BgColor				"TransparentBlack" // "TransparentBlack"   * don't know no HUD effect

		Label.TextDullColor				"Main_Color_Light"   //"White"           // "Orange"   * Class Screen and Buy Screen description text (telling you about the team and so on)
		Label.TextColor					"Main_Color_Light"   //"245 245 245 255" // "Orange"   * MAIN TITLES On the welcome, team, class and secondary buy screens also the button titles of the buy screen
		Label.TextBrightColor			"Main_Color_Light"   //"245 245 245 255" // "Orange"   * MAIN TITLES The Main Buy Menu... Main titles on buy screens like Favorites and quick buy
		Label.SelectedTextColor			"Orange"             // "Orange"             * don't know no HUD effect
		Label.BgColor					"Blank"              // "Blank"  "255 255 255 50"   * DANGER !!!! If a color is put here then a lot of lables will have the surrounding areas covered in this color. Be careful with it as it will take the whole area in that lables "wide" and "tall" setting.
		Label.DisabledFgColor1			"Blank"              // "Blank"              * don't know no HUD effect
		Label.DisabledFgColor2			"Main_Color_Disabled"     //"LightOrange"    * Some "Can't Buy This Item" buttons (the text) in the buy menu, 

		ListPanel.TextColor					"Orange"       //"Orange"              * don't know no HUD effect
		ListPanel.BgColor					"Orange"       //"Orange"              * don't know no HUD effect
		ListPanel.SelectedTextColor			"Black"        //"Black"               * don't know no HUD effect
		ListPanel.SelectedBgColor			"Red"          //"Red"                 * don't know no HUD effect
		ListPanel.SelectedOutOfFocusBgColor	"Red"          //"Red"                 * don't know no HUD effect
		ListPanel.EmptyListInfoTextColor	"Orange"       //"Orange"              * don't know no HUD effect

		Menu.TextColor					"255 255 255 128"   //"Orange"               * Drop down menu list like the Spec options this is the text font color inside the list...THAT IS NOT THE ONE UNDER YOUR MOUSE
		Menu.BgColor					"TransparentBlack"  //"TransparentBlack"     * Drop down menu list like the Spec options this is the BACKGROUND color inside the list...THAT IS NOT THE ONE UNDER YOUR MOUSE
		Menu.ArmedTextColor				"Main_Color_Light"  //"White" //"Orange"     * Drop down menu list like the Spec options this is the text font color inside the list...THAT IS THE ONE UNDER YOUR MOUSE
		Menu.ArmedBgColor				"130 130 130 200"   //"Red"(Changed to Grey) * Drop down menu list like the Spec options this is the BACKGROUND color inside the list...THAT IS NOT THE ONE UNDER YOUR MOUSE
		Menu.TextInset					"6"                 // "6"                   * don't know no HUD effect

		Panel.FgColor					"White"             // "White" *The Font color of the Chat message (while typing it only).
		Panel.BgColor					"blank"             // "blank" * Covers certain areas in the hud this color on certain screens... *if you use this you can see all the areas the hud uses... otherwise leave on the blank setting!

		ProgressBar.FgColor				"Orange"            //"Orange" * don't know no HUD effect
		ProgressBar.BgColor				"TransparentBlack"  //"TransparentBlack" * don't know no HUD effect

		PropertySheet.TextColor			"Orange"    // "Orange"                    * don't know no HUD effect
		PropertySheet.SelectedTextColor	"Orange"    // "Orange"                    * don't know no HUD effect
		PropertySheet.TransitionEffectTime	"0.25"	// time to change from one tab to another

		RadioButton.TextColor			"Orange"    // "Orange"                    * don't know no HUD effect No radio buttons to test
		RadioButton.SelectedTextColor	"Orange"    // "Orange"                    * don't know no HUD effect No radio buttons to test

		RichText.TextColor				"Main_Color"              //"White" * Font color for text in the classmenus axis and allies  "Selected Player:" ... the info about each class.
		RichText.BgColor				"Main_Color_Disabled"     //"MoreTransparentWhite" * The color of the background inside the map description box.
		RichText.SelectedTextColor		"White"                   //"White" * don't know no HUD effect
		RichText.SelectedBgColor		"MoreTransparentWhite"    //"MoreTransparentWhite" * don't know no HUD effect

		ScrollBar.Wide					12         //Added by INsane. Adjust scrollbar for map description. 17 is the normal default		
		MapDescriptionText				"Main_Color"              //"White" * The color of the text inside the map description box.

		ScrollBarButton.FgColor				"Main_Color_Light"  //"White//"Orange" * "Unarmed" (no mouse hover) ScrollBar arrow BUTTON color in the map description
		ScrollBarButton.BgColor				"30 30 30 150"          //"Blank"      * "Unarmed" (no mouse hover) ScrollBar arrow BACKGROUND color in the map descriptionThe background color of the top and bottom arrow nob
		ScrollBarButton.ArmedFgColor		"255 255 255 64"        //"Orange"     * "Armed" (while mouse hovers)ScrollBar arrow BUTTON color in the map description
		ScrollBarButton.ArmedBgColor		"30 30 30 150"          //"Blank"      * "Armed" (while mouse hovers)ScrollBar Arrow button BACKGROUND color in the map description
		ScrollBarButton.DepressedFgColor	"255 255 255 64"        //"Orange"     *(WHEN mouse CLICKS)ScrollBar Arrow BUTTON color in the map description
		ScrollBarButton.DepressedBgColor	"108 108 108 255"       //"Blank"      *(WHEN mouse CLICKS)ScrollBar Arrow button BACKGROUND color in the map description

		ScrollBarSlider.FgColor				"108 108 108 150"       // "Blank"     *ScrollBar "nob" (the one you grab and slide up and down) FILL color in the map description 
		ScrollBarSlider.BgColor				"30 30 30 150"	        // "Blank"     *ScrollBar slider track background color in the map description

		SectionedListPanel.HeaderTextColor	"ScoreHeaderText"             //"Orange"  * The scoreboard text color... Class   Status Objectives   Kills  Deaths  Ping
		SectionedListPanel.HeaderBgColor	"Blank"                       // "Blank"   * don't know no HUD effect
		SectionedListPanel.DividerColor		"Black"                       // "Black"   * The scoreboard line color below... Class   Status Objectives   Kills  Deaths  Ping 
		SectionedListPanel.TextColor		"Orange"                      // "Orange" * don't know no HUD effect
		SectionedListPanel.BrightTextColor	"Orange"                      // "Orange" * don't know no HUD effect
		SectionedListPanel.BgColor			"Scoreboard_Back"             //"TransparentLightBlack"  * The scoreboard color... Background
		SectionedListPanel.SelectedTextColor			"Black"           //"Black"  * don't know no HUD effect
		SectionedListPanel.SelectedBgColor				"Red"             // "Red"     * don't know no HUD effect
		SectionedListPanel.OutOfFocusSelectedTextColor	"Black"           // "Black" * don't know no HUD effect 
		SectionedListPanel.OutOfFocusSelectedBgColor	"ScoreHeaderHiLt" //"255 255 255 32"  *A scoreboard color...Highlights YOUR name.

		Slider.NobColor				"108 108 108 255"        // "108 108 108 255"    * don't know no HUD effect 
		Slider.TextColor			"127 140 127 255"        //"127 140 127 255"      * don't know no HUD effect
		Slider.TrackColor			"31 31 31 255"           //"31 31 31 255"         * don't know no HUD effect
		Slider.DisabledTextColor1	"117 117 117 255"        //"117 117 117 255"      * don't know no HUD effect
		Slider.DisabledTextColor2	"30 30 30 255"           //"30 30 30 255"         * don't know no HUD effect

		TextEntry.TextColor			"Main_Color_Light"       //"White" // "Orange"   * The spectator bar Title font color inside the dropdown box
		TextEntry.BgColor			"TransparentBlack"       // "TransparentBlack"   * The spectator bar Title font color inside the dropdown box
		TextEntry.CursorColor		"Orange"                 //"Orange"              * don't know no HUD effect
		TextEntry.DisabledTextColor	"Orange"                 //"Orange"              * don't know no HUD effect "Orange"
		TextEntry.DisabledBgColor	"Blank"                  //"Blank"               * don't know no HUD effect
		TextEntry.SelectedTextColor	"Black"                  //"Black"               * don't know no HUD effect
		TextEntry.SelectedBgColor	"Red"                    //"Red"                 * don't know no HUD effect
		TextEntry.OutOfFocusSelectedBgColor	"Red"            //"Red"                 * don't know no HUD effect
		TextEntry.FocusEdgeColor	"TransparentBlack"       //"TransparentBlack"    * don't know no HUD effect

		ToggleButton.SelectedTextColor	"Main_Color"         //"Orange"              * don't know no HUD effect

		Tooltip.TextColor			"TransparentBlack"
		Tooltip.BgColor				"Red"

		TreeView.BgColor			"TransparentBlack"       // "TransparentBlack"   * don't know no HUD effect Possibly a Dev tool

		WizardSubPanel.BgColor		"Blank"            // "Blank"              * WARNING: a color here will make the buy screen background solid... leave blank

		// scheme-specific colors
		"FgColor"		        "Main_Color_Trans"             // "Orange"             * widerange of items like titles, also is color of icons for weapon seletion
		"BgColor"		        "TransparentBlack"             //TransparentBlack"     * should be for the background of some titles but no effect

		"ViewportBG"		"Blank" // "Blank"                             * don't know no HUD effect
		"team0"			"204 204 204 255" // Spectators "204 204 204 255"  *no HUD effect Should be for team color but they don't work!
		"team1"			"255 64 64 255" // CT's "255 64 64 255"            *no HUD effect Should be for team color but they don't work!
		"team2"			"153 204 255 255" // T's "153 204 255 255"         *no HUD effect Should be for team color but they don't work!

		// CHudMenu
		"ItemColor"		        "Main_Color"         //"255 167 42 200"	          // "255 167 42 200"  default 255 167 42 255
		"MenuColor"		        "233 208 173 255"
		"MenuBoxBg"		        "0 0 0 100"

		// weapon selection colors
		"SelectionNumberFg"		"200 200 200 200" // "200 200 200 200"  * don't know no HUD effect Weapon select handled in another section.
		"SelectionTextFg"		"255 220 0 200" // "255 220 0 200"      * don't know no HUD effect Weapon select handled in another section.
		"SelectionEmptyBoxBg" 	"0 0 0 80" // "0 0 0 80"                * don't know no HUD effect Weapon select handled in another section.
		"SelectionBoxBg" 		"0 0 0 80" // "0 0 0 80"                * don't know no HUD effect Weapon select handled in another section.
		"SelectionSelectedBoxBg" "0 0 0 190"  // "0 0 0 190"            * don't know no HUD effect Weapon select handled in another section.
		
		// HL1-style HUD colors                        //This was ripped from multiplayer ob binaries.gcf  They are in the ClientScheme.res
		"Normal"			       "Weapon_Pick_Up"    // THIS WILL ALTER THE COLOR OF THE PICKED UP ITEMS ICONS dods may not support this	
		"Yellowish"			       "Warn_Yellow"       //"255 160 0 255"     * don't know could be a very little used color, some mods may make it show make "Weapon_Pick_Up" to be sure
		"Caution"			       "Warn_Orange"       // This is like a warning color that you just dropped a weapon or item... does not always work. Give it a warning color anyway
		// HL1-style HUD colors			

		// Top-left corner of the "Day of Defeat" on the main screen // * Title is the description!
		"Main.Title1.X"		"180"  //"48"
		"Main.Title1.Y"		"425"  //"190"
		"Main.Title1.Color"	"HUD_Panel_dodLogo"      //"255 255 255 255"

		// Top-left corner of the "SOURCE" on the main screen // * Title is the description!
		"Main.Title2.X"		"380"   //"297"
		"Main.Title2.Y"		"435"   //"218"
		"Main.Title2.Color"	"Main_Menu_Title"           //"255 255 255 128"

		// Top-left corner of the "BETA" on the main screen // * Title is the description!
		"Main.Title3.X"		"460"
		"Main.Title3.Y"		"-10"
		"Main.Title3.Color"	"HUD_Panel_dodLogo"   //"255 255 0 255"

		// Top-left corner of the menu on the main screen // * Title is the description!
		"Main.Menu.X"		"32"      //"62"
		"Main.Menu.Y"		"248"     //"272"

		// Blank space to leave beneath the menu on the main screen // * Title is the description!
		"Main.BottomBorder"	"32"
		
		// Hint message colors
		"HintMessageFg"			"Main_Color_Light"  // "255 255 255 255"   * don't know no HUD effect Could be one of the colors for rcon messages?
		"HintMessageBg" 		"0 0 0 60"          // "0 0 0 60" * Background color of the capture panel and the message box for "auto help" (Player Hints).
		
		// Hint message colors
		"RoundStateFg"			"255 255 255 255"
		"RoundStateBg" 			"0 0 0 60"
		
		HudObjectives.FgColor			"Objectives_Foreground"      //"HudPanelForeground"        * No effect on hud
		HudObjectives.BgColor			"Objectives_Background"      //"HudPanelBackground"        * The Fill color around the object icons in the upper left corner.
		HudObjectives.BorderColor		"Objectives_Border"          //"HudPanelBorder"            *This is the Border color for the object icons.
		
		HudEventInfoCard.FgColor		"HudPanelForeground"         //"HudPanelForeground"        * No effect on hud
		HudEventInfoCard.BgColor		"HudPanelBackground"         //"HudPanelBackground"        * No effect on hud
		HudEventInfoCard.BorderColor	"HudPanelBorder"             //"HudPanelBorder"            * No effect on hud

		HudStaminaBar.Active			"HudProgressBarActive"       //"HudProgressBarActive"      * Stamina... 1st Color "Rested" of the Bar in Stamina bar when rested.  
		HudStaminaBar.InActive			"HudProgressBarInActive"     //"HudProgressBarInActive"	   * Stamina... 2nd Color "Good stamina" of the Bar in Stamina bar when starting to run. 
		HudStaminaBar.ActiveLow			"HudProgressBarActiveLow"    //"HudProgressBarActiveLow"   * Stamina... 3rd Color "About to Slow down" of the Bar in Stamina bar when running. Kicks in at about 3-4 seconds.
		HudStaminaBar.InActiveLow		"HudProgressBarInActiveLow"	 //"HudProgressBarInActiveLow" * Stamina... 4th Color "Exhausted, now at walking pace" of the Bar (and Icon) in Stamina bar when running.			
		
		HudStaminaIcon.Active			"Stamina_Icon_OK"            //"HudProgressBarActive"      * Stamina Icon color... 1st Color "Rested - Good stamina".
		HudStaminaIcon.ActiveLow		"Stamina_Icon_Exhausted"     //"HudProgressBarInActiveLow" * Stamina Icon color... 2nd Color "About to Slow down - Exhausted, now at walking pace".
		
		HudMGHeatBar.InActive			"MG_Bar_Cold"                //"HudProgressBarActive"       * MG... 1st Color "Cold" of the Bar in MG heat bar.	
		HudMGHeatBar.Active			    "MG_Bar_Warm"                //"HudProgressBarActive"       * MG... 2nd Color "Warm" of the Bar and Icon in MG heat bar.
		HudMGHeatBar.InActiveLow	    "MG_Bar_Hot"                 //"HudProgressBarActive"       * MG... 3rd Color "HOT" of the Bar and Icon in MG heat bar.
		HudMGHeatBar.ActiveLow		    "MG_Bar_OverHeat"            //"HudProgressBarInActiveLow"  * MG... 4th Color "Overheated, wait cool down" of the Bar in MG heat bar. 
	
		HudMGHeatIcon.Active			"MG_Icon_Norm"               //"HudProgressBarActive"       * MG... Icon Color "cool-warm" of the Icon in MG heat bar.
		HudMGHeatIcon.ActiveLow			"MG_Icon_Hot"                //"HudProgressBarInActiveLow"  * MG... Icon Color "HOT-Overheated" of the Icon in MG heat bar.
		
		HudCaptureIcon.Active			"Cap_Icon_Mate_Go"         //"HudProgressBarInActiveLow"   * The color of the left capture Icon when you are capping. You are the left icon.
		HudCaptureIcon.InActive			"Cap_Icon_Mate_Stop"       //"HudProgressBarInActiveLow"   * The color of the Right icon, (your teammates) when waiting for a teammate also shows how many.
		HudCaptureProgressBar.Active	"Cap_Bar_Stop"             //"HudProgressBarActive"        * Color of the Capture bar segments before the other one takes over.
		HudCaptureProgressBar.InActive	"Cap_Bar_Go"               //"HudProgressBarInActive"      * Color of the Capture bar segments when counting down.
		
		HudProgressBar.Active			"Cap_Icon_Mate_Stop"       //"HudProgressBarActive"        * The "Blocked by Enemy" message on Capture
		HudProgressBar.InActive			"Cap_Icon_Mate_Go"         //"HudProgressBarInActive"      * Does not seem to do anything, but leave it this color, opposite of the above. 			
		
		HudFireSelectIcon.Active		"Bullet_Icons"             //"HudProgressBarActive"     * Color of the fireselect Icons/bullets.

		WeaponSelect.ActiveText			"Main_Color"               //"240 207 78 255"           * The weapon select panel Font color. The one that IS selected.
		WeaponSelect.InactiveText		"Main_Color_Disabled"      //"White"                    * The weapon select panel Font color. The ones that ARE NOT selected.
		WeaponSelect.ActiveBox			"HudBackgroundActive"      //"HudBackgroundActive"      * The weapon select panel background. The one that IS selected.
		WeaponSelect.ActiveBorder		"Weapon_Selected_Border"   //"240 207 78 255"           * The weapon select panel boarder. The one that IS selected.
		WeaponSelect.InactiveBox		"HudBackground"            //"HudBackground"            * The weapon select panel background. The ones that ARE NOT selected.
		WeaponSelect.InactiveBorder		"Weapon_Deselected_Border" //"255 255 255 102"          * The weapon select panel boarder. The ones that ARE NOT selected.
		WeaponSelect.NotUsable			"HudBackgroundUnusable"    //"HudBackgroundUnusable"    * The weapon select panel background. The one that HAS RUN OUT OF AMMO.
	
	}

	//
	//////////////////////// FONTS ///////////////////////////// STANDARD INsane HUD
	//
	// describes all the fonts
	Fonts
	{
		// fonts are used in order that they are listed
		// fonts listed later in the order will only be used if they fulfill a range not already filled
		// if a font fails to load then the subsequent fonts will replace
		"Default"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"12" //"12"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"480 599"
			    "dropshadow"	"1"
				
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"13" //"13"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"600 767"
				"dropshadow"	"1"			
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"14" //"14"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"768 1023"
				"antialias"	    "0"
			    "dropshadow"	"1"			
			}
			"4"
			{
				"name"		"Verdana"
				"tall"		"18" //"18"  "20"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1024 1199"
				"antialias"	    "0"
			    "dropshadow"	"1"			
			}
			"5"
			{
				"name"		"Verdana"
				"tall"		"24" //"24"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1200 6000"
				"antialias"	    "0"
			    "dropshadow"	"1"			
			}
			"6"
			{
				"name"		"Verdana"
				"tall"		"12" //"12"
				"range" 		"0x0000 0x00FF"
				"weight"		"900"
				"antialias"	    "0"
			    "dropshadow"	"1"				
			}
			"7"
			{
				"name"		"Verdana"
				"tall"		"12" //"12"
				"range" 		"0x0000 0x00FF"
				"weight"		"800"
				"antialias"	    "0"
			    "dropshadow"	"1"					
			}

			
		}
		"DefaultUnderline"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"12" //"12"
				"weight"	"500"
				"underline" "1"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
			"2"
			{
				"name"		"Arial"
				"tall"		"11" //"11"
				"range" 		"0x0000 0x00FF"
				"weight"		"800"
			}
		}
		"DefaultSmall"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"12" //"12"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"480 599"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"13" //"13"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"14" //"14"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"768 1023"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Verdana"
				"tall"		"18" //"18"  "20"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"1024 1199"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Verdana"
				"tall"		"24" //"24"
				"weight"	"0"
				"range"		"0x0000 0x017F"
				"yres"	"1200 6000"
				"antialias"	"1"
			}
			"6"
			{
				"name"		"Arial"
				"tall"		"12" //"12"
				"range" 		"0x0000 0x00FF"
				"weight"		"0"
			}
		}
		"DefaultVerySmall"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"12" //"12"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"480 599"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"13" //"13"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"14" //"14"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"768 1023"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Verdana"
				"tall"		"18" //"18"  "20"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1024 1199"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Verdana"
				"tall"		"24" //"24"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1200 6000"
				"antialias"	"1"
			}
			"6"
			{
				"name"		"Verdana"
				"tall"		"12" //"12"
				"range" 		"0x0000 0x00FF"
				"weight"		"0"
			}
			"7"
			{
				"name"		"Arial"
				"tall"		"11" //"11"
				"range" 		"0x0000 0x00FF"
				"weight"		"0"
			}
		}
		DefaultLarge
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"18" //"18"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"		"480 599"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"21" //"21"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"		"600 767"
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"22" //"22"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"		"768 1023"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Verdana"
				"tall"		"24" //"24"  "28"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"		"1024 1199"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Verdana"
				"tall"		"30" //"30"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1200 6000"
				"antialias"	"1"
			}
			"6"
			{
				"name"		"Verdana"
				"tall"		"20" //"20"
				"range" 		"0x0000 0x00FF"
				"weight"		"900"
			}
			"7"
			{
				"name"		"Arial"
				"tall"		"20" //"20"
				"range" 		"0x0000 0x00FF"
				"weight"		"800"
			}

		}
		HudHintText
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"12" //"12"
				"weight"	"700"
				"yres"	"480 599"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"13" //"13"
				"weight"	"700"
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"14" //"14"
				"weight"	"700"
				"yres"	"768 1023"
			}
			"4"
			{
				"name"		"Verdana"
				"tall"		"18" //"18"  "20"
				"weight"	"700"
				"yres"	"1024 1199"
			}
			"5"
			{
				"name"		"Verdana"
				"tall"		"24" //"24"
				"weight"	"700"
				"yres"	"1200 10000"
			}
		}
		HudNumbersSmall
		{
			"1"
			{
				"name"		"Arial"
				"tall"		"16" //"16"
				"weight"	"1000"
				"additive"	"1"
				"antialias" "1"
				"range"		"0x0000 0x017F"
			}
		}

		HudSelectionNumbers
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"11" //"11"
				"weight"	"700"
				"antialias" "1"
				"additive"	"1"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}

		HudSelectionText
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"11" //"11"
				"weight"	"700"
				"antialias" "1"
				"yres"	"1 599"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"additive"	"1"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"11" //"11"
				"weight"	"700"
				"antialias" "1"
				"yres"	"600 767"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"additive"	"1"
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"12" //"12"
				"weight"	"900"
				"antialias" "1"
				"yres"	"768 1023"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
			"4"
			{
				"name"		"Verdana"
				"tall"		"15" //"15"  "16"
				"weight"	"900"
				"antialias" "1"
				"yres"	"1024 1199"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
			"5"
			{
				"name"		"Verdana"
				"tall"		"17" //"17"
				"weight"	"1000"
				"antialias" "1"
				"yres"	"1200 10000"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}

		BudgetLabel
		{
			"1"
			{
				"name"		"Courier New"
				"tall"		"14" //"14"
				"weight"	"400"
				"outline"	"1"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}
		DebugOverlay
		{
			"1"
			{
				"name"		"Courier New"
				"tall"		"14" //"14"
				"weight"	"400"
				"outline"	"1"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}
		
		ClientTitleFont               // Main screen title  "Day of Defeat"
		{
			"1"
			{
				"name"  "Day of Defeat Logo" 
				"tall"  "30" //"76"
				"weight" "0"
				"additive" "0"
				"antialias" "1"
			}
		}	

		ClientTitleFontSmall          // Main screen title  "Source"
		{
			"1"
			{
				"name"  "Day of Defeat Logo" 
				"tall"  "70" //"20"
				"weight" "0"
				"additive" "0"
				"antialias" "1"
			}
		}
		
		ClientTitleFontPlayerIcons
		{
			"1"
			{
				"name"  "Day of Defeat Logo"    //"dodlogo.ttf"
				"tall"  "24" //"25"
				"weight" "0"
				"additive" "0"
				"antialias" "1"
			}
		}
		
		ClientTitleFontPlayerIcons2
		{
			"1"
			{
				"name"  "Day of Defeat Logo2"    //"dodlogo2.ttf" special font by INsane
				"tall"  "24" //"25"
				"weight" "0"
				"additive" "0"
				"antialias" "1"
			}
		}
		
		MOHIconssmall
		{
			"1"
			{
				"name"  "MOH Day of Defeat Logo" 
				"tall"  "10"
				"weight" "0"
				"additive" "0"
				"antialias" "1"
			}
		}
		
		MOHIconssmallBOLD
		{
			"1"
			{
				"name"  "MOH Day of Defeat Logo" 
				"tall"  "10"
				"weight" "200"
				"additive" "0"
				"antialias" "1"
			}
		}
		
		MOHIconsMED
		{
			"1"
			{
				"name"  "MOH Day of Defeat Logo" 
				"tall"  "25"
				"weight" "0"
				"additive" "0"
				"antialias" "1"
			}
		}
		
		MOHIconsLARGE
		{
			"1"
			{
				"name"  "MOH Day of Defeat Logo" 
				"tall"  "30"
				"weight" "0"
				"additive" "0"
				"antialias" "1"
			}
		}

		"BetaFont"
		{
			"1"
			{
				"name"		"Courier New"
				"tall"		"86" //"90"
				"weight"	"900"
				"range"		"0x0000 0x007F"	//	Basic Latin
				"antialias" "1"
				"additive"	"0"
			}
		}

		HudNumbers
		// DIN-regular will be used at low res, DIN-light at all other sizes.
		// note that these two fonts currently must have matching sizes ("tall")
		{
			"1"
			{
				"name"		"DIN-Regular"
				"tall"		"32" //"32"
				"weight"	"400"
				"additive"	"1"
				"antialias" "1"
				"yres"	"1 599"
				"range"		"0x0000 0x017F"
			}
			"2"
			{
				"name"		"DIN-Light"
				"tall"		"32" //"32"
				"weight"	"1000"
				"additive"	"1"
				"antialias" "1"
				"range"		"0x0000 0x017F"
			}
		}
		"CloseCaption_Normal"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16" //"16"
				"weight"	"500"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}
		"CloseCaption_Italic"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16" //"16
				"weight"	"500"
				"italic"	"1"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}
		"CloseCaption_Bold"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16" //"16
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}
		"CloseCaption_BoldItalic"
		{
			"1"
			{
				"name"		"Tahoma"
				"tall"		"16" //"16
				"weight"	"900"
				"italic"	"1"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
			}
		}
		// this is the symbol font
		"Marlett"
		{
			"1"
			{
				"name"		"Marlett"
				"tall"		"11" //"11"
				"weight"	"0"
				"symbol"	"1"
				"range"		"0x0000 0x007F"	//	Basic Latin
			}
		}
		"MenuTitle"
		{
			"1"
			{
				"name"		"Verdana Bold"
				"tall"		"18" 
				"weight"	"500"
			}
		}
		"Trebuchet24"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"24"
				"weight"	"900"
				"range"		"0x0000 0x007F"	//	Basic Latin
				"antialias" "1"
				"additive"	"1"
			}
		}
		"Trebuchet20"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"20"
				"weight"	"900"
				"range"		"0x0000 0x007F"	//	Basic Latin
				"antialias" "1"
				"additive"	"1"
			}
		}
		"Trebuchet18"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"18"
				"weight"	"900"
				"range"		"0x0000 0x007F"	//	Basic Latin
				"antialias" "1"
				"additive"	"1"
			}
		}
		"TargetID"
		{
			"1"
			{
				"name"		"Trebuchet MS"
				"tall"		"14" //"14"
				"weight"	"900"
				"range"		"0x0000 0x007F"	//	Basic Latin
				"antialias" "1"
				"additive"	"0"
			}
		}
		"ChatFont" //CHANGES FROM "Verdana" "Microsoft Sans Serif" MAKES IT SMALLER.  Set in HudLayout.res
		{
			"1"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"12"
				"weight"	"700"
				"yres"	"480 599"
				"dropshadow"	"1"
			}
			"2"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"13"
				"weight"	"700"
				"yres"	"600 767"
				"dropshadow"	"1"
			}
			"3"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"14"
				"weight"	"700"
				"yres"	"768 1023"
				"dropshadow"	"1"
			}
			"4"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"16" 
				"weight"	"700"
				"yres"	"1024 1199"
				"dropshadow"	"1"
			}
			"5"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"20"
				"weight"	"700"
				"yres"	"1200 10000"
				"dropshadow"	"1"
			}				
		}	
		MenuLargeFont
		{
			"1"
			{
				"name"		"Arial Black"
				"tall"		"32"   //"32"  changed for team menu
				"range" 		"0x0000 0x00FF"
				"weight"		"300"
				"antialias"		"1"
			}	
		}
		"KDFontSmall" // New font for kills and Deaths one size smaller than chat, has background. Set in HudLayout.res
		{
            "1"
			{
				"name"		"Microsoft Sans Serif" //"Verdana"
				"tall"		"10" //"12" = Standard "11" = Small 
				"weight"	"600" //"200"
				"range"		"0x0000 0x017F"
				"yres"	"480 599"
				"dropshadow"	"1"
                "additive"	    "0"				
			}
			"2"
			{
				"name"		"Microsoft Sans Serif" //"Verdana"
				"tall"		"11" //"13" = Standard "12" = Small 
				"weight"	"600" //"600"
				"range"		"0x0000 0x017F"
				"yres"	"600 767"
				"dropshadow"	"1"
                "additive"	    "0"				
			}
			"3"
			{
				"name"		"Microsoft Sans Serif" //"Verdana"
				"tall"		"12" //"14" = Standard "13" = Small 
				"weight"	"900" //"200"
				"range"		"0x0000 0x017F"
				"yres"	"768 1023"
				"antialias"	"0"
				"dropshadow"	"1"
                "additive"	    "0"				
			}
			"4"
			{
				"name"		"Microsoft Sans Serif" //"Verdana"
				"tall"		"13" //"16" = Standard "14" = Small 
				"weight"	"900" //"200"
				"range"		"0x0000 0x017F"
				"yres"	"1024 1199"
				"antialias"	"0"
				"dropshadow"	"1"
                "additive"	    "0"				
			}
			"5"
			{
				"name"		"Microsoft Sans Serif" //"Verdana"
				"tall"		"17" //"20" = Standard "18" = Small 
				"weight"	"900" //"200"
				"range"		"0x0000 0x017F"
				"yres"	"1200 6000"
				"antialias"	"0"
				"dropshadow"	"1"
                "additive"	    "0"
			}
		}
		"WINFontMedium"
		{
			"1"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"15"
				"weight"	"400"
				"yres"	"480 599"
				"dropshadow"	"1"
                                "additive"	"0"
			}
			"2"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"16"
				"weight"	"400"
				"yres"	"600 767"
				"dropshadow"	"1"
                                "additive"	"0"
			}
			"3"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"17"
				"weight"	"400"
				"yres"	"768 1023"
				"dropshadow"	"1"
                                "additive"	"0"
			}
			"4"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"19"
				"weight"	"400"
				"yres"	"1024 1199"
				"dropshadow"	"1"
                                "additive"	"0"
			}
			"5"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"23"
				"weight"	"400"
				"yres"	"1200 10000"
				"dropshadow"	"1"
                                "additive"	"0"
			}
		}		
		"WINFontSmall" // New Font for smaller winpanels. Set this in Win_Allies.res and Win_Axis.res.
		{
			"1"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"11"
				"weight"	"400"
				"yres"	"480 599"
				"dropshadow"	"1"
                "additive"	    "0"
			}
			"2"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"12"
				"weight"	"400"
				"yres"	"600 767"
				"dropshadow"	"1"
                "additive"	    "0"
			}
			"3"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"13"
				"weight"	"400"
				"yres"	"768 1023"
				"dropshadow"	"1"
                "additive"	    "0"
			}
			"4"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"15" //"15"
				"weight"	"400"
				"yres"	"1024 1199"
				"dropshadow"	"1"
                "additive"	    "0"
			}
			"5"
			{
				"name"		"Microsoft Sans Serif"
				"tall"		"20"
				"weight"	"400"
				"yres"	"1200 10000"
				"dropshadow"	"1"
                "additive"	    "0"
			}
		}
		"KDFontLIGHT" // New font for kills and Deaths one size smaller than chat, is lighter than "KDFontSmall". Set in HudLayout.res
		{
            "1"
			{
				"name"		"Microsoft Sans Serif" //"Verdana"
				"tall"		"11" //"12" = Standard "11" = Small 
				"weight"	"600" //"200"
				"range"		"0x0000 0x017F"
				"yres"	"480 599"
				"dropshadow"	"0"
                "additive"	    "1"				
			}
			"2"
			{
				"name"		"Microsoft Sans Serif" //"Verdana"
				"tall"		"12" //"13" = Standard "12" = Small 
				"weight"	"600" //"600"
				"range"		"0x0000 0x017F"
				"yres"	"600 767"
				"dropshadow"	"0"
                "additive"	    "1"				
			}
			"3"
			{
				"name"		"Microsoft Sans Serif" //"Verdana"
				"tall"		"13" //"14" = Standard "13" = Small 
				"weight"	"900" //"200"
				"range"		"0x0000 0x017F"
				"yres"	"768 1023"
				"antialias"	"0"
				"dropshadow"	"0"
                "additive"	    "1"				
			}
			"4"
			{
				"name"		"Microsoft Sans Serif" //"Verdana"
				"tall"		"14" //"16" = Standard "14" = Small 
				"weight"	"900" //"200"
				"range"		"0x0000 0x017F"
				"yres"	"1024 1199"
				"antialias"	"0"
				"dropshadow"	"0"
                "additive"	    "1"				
			}
			"5"
			{
				"name"		"Microsoft Sans Serif" //"Verdana"
				"tall"		"18" //"20" = Standard "18" = Small 
				"weight"	"900" //"200"
				"range"		"0x0000 0x017F"
				"yres"	"1200 6000"
				"antialias"	"0"
				"dropshadow"	"0"
                "additive"	    "1"
			}

		}				
		"TimerFontSmall"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"12"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"480 599"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"13"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"600 767"
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"14"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"768 1023"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Verdana"
				"tall"		"20"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1024 1199"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Verdana"
				"tall"		"24"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1200 6000"
				"antialias"	"1"
			}
			"6"
			{
				"name"		"Verdana"
				"tall"		"12"
				"range" 		"0x0000 0x00FF"
				"weight"		"900"
			}
			"7"
			{
				"name"		"Arial"
				"tall"		"12"
				"range" 		"0x0000 0x00FF"
				"weight"		"800"
			}		
        }
		
		"TimerFontLarge"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"16"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"		"480 599"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"18"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"		"600 767"
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"21"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"		"768 1023"
				"antialias"	"1"
			}
			"4"
			{
				"name"		"Verdana"
				"tall"		"22"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"		"1024 1199"
				"antialias"	"1"
			}
			"5"
			{
				"name"		"Verdana"
				"tall"		"28"
				"weight"	"900"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"	"1200 6000"
				"antialias"	"1"
			}
			"6"
			{
				"name"		"Verdana"
				"tall"		"20"
				"range" 		"0x0000 0x00FF"
				"weight"		"900"
			}
			"7"
			{
				"name"		"Arial"
				"tall"		"20"
				"range" 		"0x0000 0x00FF"
				"weight"		"800"
			}
		}
		"ScoreboardVerySmall"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"8"
				"weight"	"400"
				"additive"	"1"
				"antialias" "0"
			}
		}		
		// Used by scoreboard and spectator UI for names which don't map in the normal fashion
		"DefaultVerySmallFallBack"
		{
			"1"
			{
				"name"		"Verdana"
				"tall"		"10"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"		"480 599"
				"antialias"	"1"
			}
			"2"
			{
				"name"		"Verdana"
				"tall"		"12"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"		"600 1199"
				"antialias"	"1"
			}
			"3"
			{
				"name"		"Verdana"
				"tall"		"15"
				"weight"	"0"
				"range"		"0x0000 0x017F" //	Basic Latin, Latin-1 Supplement, Latin Extended-A
				"yres"		"1200 6000"
				"antialias"	"1"
			}
		}

	}

	//
	//////////////////// BORDERS //////////////////////////////
	//
	// describes all the border types
	Borders
	{
		NoBorder
			{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Blank"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Blank"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Blank"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Blank"
					"offset" "0 0"
				}
			}
		}
		
		BaseBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}
		
		TitleButtonBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDisabledBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "BgColor"
					"offset" "1 0"
				}
			}
			Top
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "BgColor"
					"offset" "0 0"
				}
			}
		}

		TitleButtonDepressedBorder
		{
			"inset" "1 1 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonBorder
		{
			"inset" "1 0 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		ScrollBarButtonDepressedBorder
		{
			"inset" "2 2 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}
		
		ButtonBorder
		{
			"inset" "0 0 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		FrameBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "0 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "0 0"
				}
			}
		}

		TabBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}

		TabActiveBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "ControlBG"
					"offset" "6 2"
				}
			}
		}


		ToolTipBorder
		{
			"inset" "0 0 1 0"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		// this is the border used for default buttons (the button that gets pressed when you hit enter)
		ButtonKeyFocusBorder
		{
			"inset" "0 0 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		ButtonDepressedBorder
		{
			"inset" "0 0 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 1"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}

		ComboBoxBorder
		{
			"inset" "0 0 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}

		MenuBorder
		{
			"inset" "1 1 1 1"
			Left
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 1"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "1 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}
		}
		BrowserBorder
		{
			"inset" "0 0 0 0"
			Left
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Right
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}

			Top
			{
				"1"
				{
					"color" "Border.Dark"
					"offset" "0 0"
				}
			}

			Bottom
			{
				"1"
				{
					"color" "Border.Bright"
					"offset" "0 0"
				}
			}
		}
	}

	//////////////////////// CUSTOM FONT FILES /////////////////////////////
	//
	// specifies all the custom (non-system) font files that need to be loaded to service the above described fonts
	CustomFontFiles
	{
		"1"		"resource/DODlogo.ttf"
		"2"		"resource/DODlogo2.ttf"
	}
}